/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities.animation;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandlerData;
import com.ferreusveritas.dynamictrees.entities.animation.IAnimationHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnimationHandlerPhysics
implements IAnimationHandler {
    @Override
    public String getName() {
        return "physics";
    }

    HandlerData getData(EntityFallingTree entity) {
        return entity.animationHandlerData instanceof HandlerData ? (HandlerData)entity.animationHandlerData : new HandlerData();
    }

    @Override
    public void initMotion(EntityFallingTree entity) {
        entity.animationHandlerData = new HandlerData();
        BlockPos cutPos = entity.getDestroyData().cutPos;
        long seed = entity.field_70170_p.field_73012_v.nextLong();
        Random random = new Random(seed ^ ((long)cutPos.func_177958_n() << 32 | (long)cutPos.func_177952_p()));
        float mass = entity.getDestroyData().woodVolume;
        float inertialMass = MathHelper.func_76131_a((float)mass, (float)1.0f, (float)3.0f);
        entity.field_70159_w /= (double)inertialMass;
        entity.field_70181_x /= (double)inertialMass;
        entity.field_70179_y /= (double)inertialMass;
        this.getData((EntityFallingTree)entity).rotPit = (random.nextFloat() - 0.5f) * 4.0f / inertialMass;
        this.getData((EntityFallingTree)entity).rotYaw = (random.nextFloat() - 0.5f) * 4.0f / inertialMass;
        EnumFacing cutDir = entity.getDestroyData().cutDir;
        entity.field_70159_w += (double)cutDir.func_176734_d().func_82601_c() * 0.1;
        entity.field_70181_x += (double)cutDir.func_176734_d().func_96559_d() * 0.1;
        entity.field_70179_y += (double)cutDir.func_176734_d().func_82599_e() * 0.1;
        EntityFallingTree.standardDropLeavesPayLoad(entity);
    }

    @Override
    public void handleMotion(EntityFallingTree entity) {
        if (entity.landed) {
            return;
        }
        entity.field_70181_x -= (double)0.03f;
        entity.field_70159_w *= (double)0.98f;
        entity.field_70181_x *= (double)0.98f;
        entity.field_70179_y *= (double)0.98f;
        this.getData((EntityFallingTree)entity).rotYaw *= 0.98f;
        this.getData((EntityFallingTree)entity).rotPit *= 0.98f;
        entity.field_70165_t += entity.field_70159_w;
        entity.field_70163_u += entity.field_70181_x;
        entity.field_70161_v += entity.field_70179_y;
        entity.field_70125_A = MathHelper.func_76142_g((float)(entity.field_70125_A + this.getData((EntityFallingTree)entity).rotPit));
        entity.field_70177_z = MathHelper.func_76142_g((float)(entity.field_70177_z + this.getData((EntityFallingTree)entity).rotYaw));
        int radius = 8;
        if (entity.getDestroyData().getNumBranches() <= 0) {
            return;
        }
        IExtendedBlockState state = entity.getDestroyData().getBranchBlockState(0);
        if (TreeHelper.isBranch((IBlockState)state)) {
            radius = ((BlockBranch)state.func_177230_c()).getRadius((IBlockState)state);
        }
        World world = entity.field_70170_p;
        AxisAlignedBB fallBox = new AxisAlignedBB(entity.field_70165_t - (double)radius, entity.field_70163_u, entity.field_70161_v - (double)radius, entity.field_70165_t + (double)radius, entity.field_70163_u + 1.0, entity.field_70161_v + (double)radius);
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        IBlockState collState = world.func_180495_p(pos);
        if (!TreeHelper.isLeaves(collState) && !TreeHelper.isBranch(collState) && collState.func_177230_c() != ModBlocks.blockTrunkShell) {
            if (collState.func_177230_c() instanceof BlockLiquid) {
                entity.field_70181_x += (double)0.03f;
                entity.field_70159_w *= (double)0.8f;
                entity.field_70181_x *= (double)0.8f;
                entity.field_70179_y *= (double)0.8f;
                this.getData((EntityFallingTree)entity).rotYaw *= 0.8f;
                this.getData((EntityFallingTree)entity).rotPit *= 0.8f;
                entity.field_70181_x += 0.01;
                entity.onFire = false;
            } else {
                AxisAlignedBB collBox = collState.func_185890_d((IBlockAccess)world, pos);
                if (collBox != null && fallBox.func_72326_a(collBox = collBox.func_186670_a(pos))) {
                    entity.field_70181_x = 0.0;
                    entity.field_70167_r = entity.field_70163_u = collBox.field_72337_e;
                    entity.landed = true;
                    entity.field_70122_E = true;
                    if (entity.onFire && entity.field_70170_p.func_175623_d(pos.func_177984_a())) {
                        entity.field_70170_p.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
        }
    }

    @Override
    public void dropPayload(EntityFallingTree entity) {
        World world = entity.field_70170_p;
        entity.getPayload().forEach(i -> Block.func_180635_a((World)world, (BlockPos)new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), (ItemStack)i));
        entity.getDestroyData().leavesDrops.forEach(bis -> Block.func_180635_a((World)world, (BlockPos)entity.getDestroyData().cutPos.func_177971_a((Vec3i)bis.pos), (ItemStack)bis.stack));
    }

    @Override
    public boolean shouldDie(EntityFallingTree entity) {
        boolean dead;
        boolean bl = dead = entity.landed || entity.field_70173_aa > 120;
        if (dead) {
            entity.cleanupRootyDirt();
        }
        return dead;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTransform(EntityFallingTree entity, float entityYaw, float partialTicks) {
        float yaw = MathHelper.func_76142_g((float)com.ferreusveritas.dynamictrees.util.MathHelper.angleDegreesInterpolate(entity.field_70126_B, entity.field_70177_z, partialTicks));
        float pit = MathHelper.func_76142_g((float)com.ferreusveritas.dynamictrees.util.MathHelper.angleDegreesInterpolate(entity.field_70127_C, entity.field_70125_A, partialTicks));
        Vec3d mc = entity.getMassCenter();
        GlStateManager.func_179137_b((double)mc.field_72450_a, (double)mc.field_72448_b, (double)mc.field_72449_c);
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pit, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)(-mc.field_72450_a - 0.5), (double)(-mc.field_72448_b), (double)(-mc.field_72449_c - 0.5));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRender(EntityFallingTree entity) {
        return true;
    }

    class HandlerData
    extends AnimationHandlerData {
        float rotYaw = 0.0f;
        float rotPit = 0.0f;

        HandlerData() {
        }
    }
}

